﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SeekerController : MonoBehaviour
{
    public bool IsRevealing { get; set; } = false;

    private async void OnTriggerStay2D(Collider2D collision)
    {
        if (GameController.Instance.CurrentGamePhase.GetType() == typeof(SeekingPhase))
        {
            if (Input.GetKeyUp(KeyCode.Space) || Input.GetKeyUp("joystick button 0"))
            {
                if (!IsRevealing)
                {
                    if (collision is BoxCollider2D)
                    {
                        if (collision.tag == Constants.HidableTag)
                        {
                            if (GameController.Instance.TryUncoverHider(collision.gameObject))
                            {
                                //We've found the hider, stop moving, begin revealing
                                IsRevealing = true;
                                GameController.Instance.SetCharacterLegend(InputManager.Instance.InputState, Constants.CharacterLegendType.Hide, Constants.PlayerRole.Seeker);
                                await collision.gameObject.GetComponent<HidableController>().Reveal(true);
                                GameController.Instance.RevealHider();
                            }

                            else
                            {
                                //Didn't find the hider so just play the reveal animation of the object
                                collision.gameObject.GetComponent<HidableController>().Reveal();
                            }
                        }

                        else
                        {
                            Debug.Log("This isn't a hidable location - the hider can't be in here. Did you remember to set the game object tag?");
                        }
                    }
                }
            }

            else
            {
                if (collision is BoxCollider2D)
                {
                    if (collision.tag == Constants.HidableTag)
                    {
                        //We're colliding, so let's set the legend
                        GameController.Instance.SetCharacterLegend(InputManager.Instance.InputState, Constants.CharacterLegendType.Hide, Constants.PlayerRole.Seeker);
                    }
                }
            }
        }
    }

    private void OnTriggerExit2D(Collider2D collision)
    {
        //We're no longer colliding, so reset the legend
        GameController.Instance.SetCharacterLegend(InputManager.Instance.InputState, Constants.CharacterLegendType.None, Constants.PlayerRole.Seeker);
    }
}
